%compute the steady state of NK Model 

function [ys,params,check]=GK_financial_steadystate(~,~,M_,~)
global M_
%% DO NOT CHANGE THIS PART.
%%
%% Here we load the values of the deep parameters in a loop.
%%
%NumberOfParameters = M_.param_nbr;                            % Number of deep parameters.
% for i = 1:NumberOfParameters                                  % Loop...
%   paramname = cell2mat(deblank(M_.param_names(i,:)));                   %    Get the name of parameter i. 
%   eval([ paramname ' = M_.params(' int2str(i) ');']);         %    Get the value of parameter i.
% end                                                           % End of the loop.  
check = 0;

gy = M_.params(1);
alp = M_.params(2);
delta = M_.params(3);
zzetap = M_.params(4);
zzetaw = M_.params(5);
sigma_c = M_.params(6);
chi = M_.params(7);
gam = M_.params(8);
phiX = M_.params(9);
xip = M_.params(10);
xiw = M_.params(11);
gammap = M_.params(12);
gammaw = M_.params(13);
PIE_bar = M_.params(14);
g_bar = M_.params(15);
Rn_bar = M_.params(16);
rho_r = M_.params(17);
theta_pie = M_.params(18);
theta_y = M_.params(19);
theta_dy = M_.params(20);
rhoA = M_.params(21);
rhoG = M_.params(22);
rhoMCS = M_.params(23);
rhoMRSS = M_.params(24);
rhoMPS = M_.params(25);
rhoRPS = M_.params(26);
rhoIS = M_.params(27);
sigmaB = M_.params(28);
spreadtarg = M_.params(29);
levtarg = M_.params(30);
epsilon = M_.params(31);
xequitytarg = M_.params(32);
sigma_s = M_.params(33);
wr = M_.params(34);
apsi = M_.params(35);
%%

%% THIS BLOCK IS MODEL SPECIFIC.
%%
%% Here the user has to define the steady state.
%%

H0       = 0.5;
KYW0     = 5.0;
thetaFF0 = 1.0;
xiB0     = 0.0025;
x0      = [log(H0); log(KYW0); log(thetaFF0); log(xiB0)];
options = optimset('TolFun',1e-9,'TolX',1e-9,'MaxIter', 5000, 'MaxFunEvals', 5000, 'Display','off');
x       = fsolve(@ss_fun_GK,x0,options);

H       = exp(x(1));
KYW     = exp(x(2));
thetaFF = exp(x(3));
xiB     = exp(x(4));

g       = g_bar/100;
betta   = (PIE_bar/100+1)/(Rn_bar/100+1)/(1+g)^(-sigma_c); % (273)

A       = 1;
MCS     = 1;
MRSS    = 1;
IS      = 1;
MPS     = 1;
RPS     = 1;

PIE     = PIE_bar/100+1;

S       = 0; % (368)
Sdash   = 0; % (369)
PIEw    = (1+g)*PIE; % (370)
Q       = 1; % (371)
LAMBDA  = betta*(1+g)^(-sigma_c); % (372)
PO      = ((1-xip*PIE^((gammap-1)*(1-zzetap)))/(1-xip))^(1/(1-zzetap)); % (373)
Deltap  = (1-xip)/(1-xip*PIE^(zzetap*(1-gammap)))*PO^(-zzetap); % (374)
MC      = (1-1/zzetap)*1/MCS*(1-xip*(1+g)*LAMBDA*PIE^(zzetap*(1-gammap)))/(1-xip*(1+g)*LAMBDA*PIE^((zzetap-1)*(1-gammap)))*PO; % (375)
PWP     = MC; % (376)
WO      = ((1-xiw*PIE^(gammaw*(1-zzetaw))*PIEw^(zzetaw-1))/(1-xiw))^(1/(1-zzetaw)); % (377)
Deltaw  = (1-xiw)/(1-xiw*PIEw^(zzetaw)/PIE^(gammaw*zzetaw))*WO^(-zzetaw); % (378)
Hd      = H/Deltaw; % (379)
rK      = (1-alp)*(1+g)/KYW*PWP; % (380)
YW      = A*Hd*(KYW/(1+g))^((1-alp)/alp); % (381)
K       = YW*KYW; % (382)
Y       = YW/Deltap; % (383)
I       = K/IS*(g+delta)/(1+g); % (384)
G       = gy*Y; % (385)
C       = Y-G-I; % (386)
JJw     = Hd/(1-xiw*LAMBDA*PIEw^zzetaw*PIE^(gammaw*(1-zzetaw)-1)); % (387)
W       = alp*PWP*YW/Hd; % (388)
Jw      = WO*W*JJw; % (389)
Wh      = (1-xiw*(1+g)*LAMBDA*PIEw^zzetaw/PIE^(gammaw*zzetaw))*(1-1/zzetaw)*Jw/(Hd*MRSS); % (390)
U       = (C*(1-chi/(1+g)))^(1-sigma_c)/(1-sigma_c)*exp((sigma_c-1)*H^(1+apsi)/(1+apsi)); % (391)
xequity = xequitytarg;
kappaFF = -epsilon/xequitytarg; % (410)
R       = 1/(LAMBDA); % (392)
RK      = rK+(1-delta); % (393)
spread  = RK-R; % (394)
Re      = 1/(LAMBDA); % (395)
q       = rK/(Re-1+delta); % (396)
Sasset  = K; % (397)
mue     = 0; % (398)
Nn      = xiB/(1+g)*(rK+(1-delta)*Q)*Sasset; % (399)
E       = xequity*Q*Sasset/q; % (400)
Thetax  = thetaFF*(1+epsilon*xequity+kappaFF*xequity^2/2); % (401)
No      = sigmaB*((rK+(1-delta-R)*Q)*Sasset-(rK+(1-delta-R)*q)*E+R*Nn)/(1+g-sigmaB*R); % (402)
N       = No+Nn; % (403)
phiB    = Q*Sasset/N; % (404)
omega   = (1-sigmaB)+sigmaB*Thetax*phiB; % (405)
nud     = LAMBDA*omega*R; % (406)
mus     = Thetax-nud/phiB-mue*xequity; % (407)

V         = U/(1-betta*(1+g)^(1-sigma_c)); % (411)
Vmodified = V;
X         = 1+g; % (412)
lambda    = (1-sigma_c)*U/(C-chi*C/(1+g))-betta*chi*(1-sigma_c)*U/(1+g)^(1-sigma_c)/((1+g)*C-chi*C); % (413)
Rn        = R*PIE; % (414)
Jp        = Y*MC*MCS/((1-1/zzetap)*(1-xip*(1+g)*LAMBDA*PIE^(zzetap*(1-gammap)))); % (415);
JJp       = Jp/PO; % (416)
CEquiv    = (1.01^(1-sigma_c)-1)*U/(1-betta*(1+g)^(1-sigma_c)); % (417)

DThetax   = thetaFF*(epsilon+kappaFF*xequity); % (418)
D         = Q*Sasset-N-q*E; % (419)
lambdaFF  = (mus+mue*xequity)/(Thetax-mus-mue*xequity); % (420)
UH      = -(1-sigma_c)*U*H^apsi;

dyobs   = log((1+g));
dcobs   = log((1+g));
dinvobs = log((1+g));
dwobs   = log((1+g));
labobs  = 0;
robs    = (Rn-1);
pinfobs = (log(PIE));
spreadobs = spread;

%% END OF THE MODEL SPECIFIC BLOCK.

%% DO NOT CHANGE THIS PART.
%%
%% Here we define the steady state vZNues of the endogenous variables of
%% the model.
%%
NumberOfEndogenousVariables = M_.endo_nbr;                    % Number of endogenous variables.
ys = zeros(NumberOfEndogenousVariables,1);                    % Initialization of ys (steady state).
% for ii = 1:NumberOfEndogenousVariables                        % Loop...
%     varname = cell2mat(deblank(M_.endo_names(ii,:)));          %    Get the name of endogenous variable i.         
%     eval([ 'ys(' num2str(ii) ') = ' varname ';' ]);           %    Get the steady state vZNue of this variable.    
% end                                                           % End of the loop.
ys(1) = V;
ys(2) = Vmodified;
ys(3) = U;
ys(4) = C;
ys(5) = H;
ys(6) = K;
ys(7) = S;
ys(8) = X;
ys(9) = I;
ys(10) = IS;
ys(11) = Sdash;
ys(12) = lambda;
ys(13) = Wh;
ys(14) = rK;
ys(15) = RPS;
ys(16) = R;
ys(17) = Q;
ys(18) = Rn;
ys(19) = PIE;
ys(20) = PIEw;
ys(21) = W;
ys(22) = Jw;
ys(23) = Hd;
ys(24) = MRSS;
ys(25) = JJw;
ys(26) = WO;
ys(27) = Deltaw;
ys(28) = YW;
ys(29) = A;
ys(30) = PWP;
ys(31) = MC;
ys(32) = Jp;
ys(33) = Y;
ys(34) = MCS;
ys(35) = JJp;
ys(36) = PO;
ys(37) = Deltap;
ys(38) = MPS;
ys(39) = G;
ys(40) = RK;
ys(41) = spread;
ys(42) = CEquiv;
ys(43) = q;
ys(44) = Sasset;
ys(45) = E;
ys(46) = D;
ys(47) = Re;
ys(48) = xequity;
ys(49) = lambdaFF;
ys(50) = Thetax;
ys(51) = mus;
ys(52) = mue;
ys(53) = DThetax;
ys(54) = phiB;
ys(55) = nud;
ys(56) = omega;
ys(57) = N;
ys(58) = No;
ys(59) = Nn;
ys(60) = xiB;
ys(61) = thetaFF;
ys(62) = kappaFF;
ys(63) = dyobs;
ys(64) = dcobs;
ys(65) = pinfobs;
ys(66) = robs;
ys(67) = labobs;
ys(68) = spreadobs;
ys(69) = dinvobs;
ys(70) = dwobs;
ys(71) = UH;

params = M_.params;
